/**
 * 
 */
package com.xunlei.channel.db.orm;

import java.util.List;

import com.xunlei.channel.db.pojo.ContactResult;


/**
 * @author lishaojun
 */
public interface ContactResultMapper {

    /**
     * 保存到签约表
     * 
     * @param ContactResult
     */
    void saveContactResult(ContactResult contactResult);
    
    /**
     * 更新签约表
     * 
     * @param ContactResult
     */
    void updateContactResult(ContactResult contactResult);
    
    /**
     * 通过迅雷Id来查找签约表信息
     * 
     * @param xunleiId
     * @return ContactResult or null
     */
    ContactResult getContactResult(String xunleiId);

    
    /**
     * 查询所有的签约表信息
     * @return List
     */
    List<ContactResult> listAllContactResult();

}
