/**
 * Project: dbservice
 * 
 * File Created at 2014-12-4
 * lishaojun
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.orm;

import java.util.List;

import com.xunlei.channel.db.pojo.Biz;

/**
 * @author gonglijian
 * @author lishaojun
 */
public interface BizMapper {

    /**
     * 得到所有的业务方信息
     * 
     * @return List of Biz
     */
    List<Biz> listAllBizs();

    /**
     * 保存业务方信息到数据库
     * 
     * @param biz
     */
    void saveBiz(Biz biz);

    /**
     * 通过bizNo得到业务方信息
     * 
     * @param bizNo 唯一业务号
     * @return Biz or null
     */
    Biz getBiz(String bizNo);

}
