/**
 * Project: dbservice
 * 
 * File Created at 2014-12-2
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.common.Constants;
import com.xunlei.channel.db.dao.PayOrderOkDAO;
import com.xunlei.channel.db.orm.PayOrderOkMapper;
import com.xunlei.channel.db.pojo.PayOrderOk;

@Service
public class PayOrderOkDAOImpl implements PayOrderOkDAO {

    private Logger           logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private PayOrderOkMapper payOrderOkMapper;

    @Transactional(readOnly = false)
    @Override
    public void savePayOrderOk(PayOrderOk payOrderOk) throws DataAccessException {
        payOrderOkMapper.savePayOrderOk(payOrderOk);
    }

    @Override
    public PayOrderOk getPayOrderOk(String xunleiPayId) throws DataAccessException {
        Assert.notNull(xunleiPayId);
        return payOrderOkMapper.getPayOrderOk(xunleiPayId);
    }

    @Transactional(readOnly = false)
    @Override
    public void updatePayOrderOk(PayOrderOk payOrderOk) throws DataAccessException {
        Assert.notNull(payOrderOk);
        logger.debug("save payOrderOk...xunleiPayId:{}", payOrderOk.getXunleiPayId());
        payOrderOkMapper.updatePayOrderOk(payOrderOk);
    }

    @Override
    public PayOrderOk getPayOrderOkByBizNoAndBizOrderId(String bizNo, String bizOrderId)
            throws DataAccessException {
        Assert.notNull(bizNo);
        Assert.notNull(bizOrderId);
        return payOrderOkMapper.getPayOrderOkByBizNoAndBizOrderId(bizNo, bizOrderId);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayOrderOkDAO#getPayOrderOkSendNoticeStatus
     * (java.lang.String)
     */
    @Override
    public String getPayOrderOkSendNoticeStatus(String xunleiPayId) throws DataAccessException {
        Assert.notNull(xunleiPayId);
        return this.payOrderOkMapper.getPayOrderOkSendNoticeStatus(xunleiPayId);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayOrderOkDAO#updateSendNoticeStatus(java.lang
     * .String, java.lang.String)
     */
    @Transactional(readOnly = false)
    @Override
    public void updateSendNoticeStatus(String xunleiPayId, String sendNoticeStatus)
            throws DataAccessException {
        Assert.notNull(xunleiPayId);
        Assert.notNull(sendNoticeStatus);
        this.payOrderOkMapper.updateSendNoticeStatus(xunleiPayId, sendNoticeStatus);
    }

    @Override
    public List<String> listUnsuccessNoticeXunleiPayId(Date fromTime, Date endTime)
            throws DataAccessException {
        if (null == fromTime && null == endTime) {
            return null;
        }
        return this.payOrderOkMapper.listUnsuccessNoticeXunleiPayId(
                Constants.SEND_NOTICE_STATUS_FAIL, fromTime, endTime);
    }

}
