/**
 * Project: dbservice
 * 
 * File Created at 2014-12-2
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.PayOrderFailDAO;
import com.xunlei.channel.db.orm.PayOrderFailMapper;
import com.xunlei.channel.db.pojo.PayOrderFail;

@Service
public class PayOrderFailDAOImpl implements PayOrderFailDAO {

    private Logger             logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private PayOrderFailMapper payOrderFailMapper;

    @Transactional(readOnly = false)
    @Override
    public void savePayOrderFail(PayOrderFail payOrderFail) throws DataAccessException {
        payOrderFailMapper.savePayOrderFail(payOrderFail);
    }

    @Override
    public PayOrderFail getPayOrderFail(String xunleiPayId) throws DataAccessException {
        Assert.notNull(xunleiPayId);
        return payOrderFailMapper.getPayOrderFail(xunleiPayId);
    }

    @Transactional(readOnly = false)
    @Override
    public void updatePayOrderFail(PayOrderFail payOrderFail) throws DataAccessException {
        Assert.notNull(payOrderFail);
        logger.debug("save payOrderOk...xunleiPayId:{}", payOrderFail.getXunleiPayId());
        payOrderFailMapper.updatePayOrderFail(payOrderFail);
    }

}
