/**
 * Project: dbservice
 * 
 * File Created at 2014-12-2
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.orm.PayOrderMapper;
import com.xunlei.channel.db.pojo.PayOrder;

@Service
public class PayOrderDAOImpl implements PayOrderDAO {

    private Logger         logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private PayOrderMapper payOrderMapper;

    @Transactional(readOnly = false)
    @Override
    public void savePayOrder(PayOrder payOrder) throws DataAccessException {
        Assert.notNull(payOrder);
        logger.debug("savePayOrder...xunleiPayId:{}", payOrder.getXunleiPayId());
        payOrderMapper.savePayOrder(payOrder);
    }

    @Override
    public PayOrder getPayOrder(String xunleiPayId) throws DataAccessException {
        Assert.notNull(xunleiPayId);
        return payOrderMapper.getPayOrder(xunleiPayId);
    }

    @Override
    public PayOrder getPayOrderByBizNoAndBizOrderId(String bizNo, String bizOrderId)
            throws DataAccessException {
        Assert.notNull(bizNo);
        Assert.notNull(bizOrderId);
        return payOrderMapper.getPayOrderByBizNoAndBizOrderId(bizNo, bizOrderId);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayOrderDAO#getCountByBizNoAndBizOrderId(java
     * .lang.String, java.lang.String)
     */
    @Override
    public int getCountByBizNoAndBizOrderId(String bizNo, String bizOrderId)
            throws DataAccessException {
        Assert.notNull(bizOrderId);
        Assert.notNull(bizNo);
        return this.payOrderMapper.getCountByBizNoAndBizOrderId(bizNo, bizOrderId);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayOrderDAO#updatePayOrderStatusAndChannelId
     * (java.lang.String, java.lang.String)
     */
    @Transactional(readOnly = false)
    @Override
    public void updatePayOrderStatusAndChannelId(String xunleiPayId, String orderStatus,
                                                 String channelOrderId) throws DataAccessException {
        Assert.notNull(xunleiPayId);
        Assert.notNull(orderStatus);
        this.payOrderMapper.updatePayOrderStatusAndChannelId(xunleiPayId, orderStatus,
                channelOrderId);
    }

}
