/**
 * Project: dbservice
 * 
 * File Created at 2014年12月11日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.PayNoticeOkDAO;
import com.xunlei.channel.db.orm.PayNoticeOkMapper;
import com.xunlei.channel.db.pojo.PayNoticeOk;

/**
 * TODO Comment of PayNoticeOkDAOImpl
 * 
 * @author gonglijian
 */
@Service
public class PayNoticeOkDAOImpl implements PayNoticeOkDAO {
    private Logger            logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private PayNoticeOkMapper payNoticeOkMapper;

    /*
     * (non-Javadoc)
     * @see com.xunlei.channel.db.dao.PayNoticeOkDAO#getPayNoticeOk(java.lang
     * .String)
     */
    @Override
    public PayNoticeOk getPayNoticeOk(String xunleiPayId) throws DataAccessException {
        Assert.notNull(xunleiPayId);
        logger.debug("getPayNoticeOk...xunleiPayId:{}", xunleiPayId);
        return this.payNoticeOkMapper.getPayNoticeOk(xunleiPayId);
    }

    /*
     * (non-Javadoc)
     * @see com.xunlei.channel.db.dao.PayNoticeOkDAO#savePayNoticeOk(com.xunlei
     * .channel.db.pojo.PayNoticeOk)
     */
    @Transactional(readOnly = false)
    @Override
    public void savePayNoticeOk(PayNoticeOk payNoticeOk) throws DataAccessException {
        Assert.notNull(payNoticeOk);
        logger.debug("savePayNoticeOk...xunleiPayId:{}", payNoticeOk.getXunleiPayId());
        this.payNoticeOkMapper.savePayNoticeOk(payNoticeOk);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayNoticeOkDAO#updatePayNoticeOk(com.xunlei
     * .channel.db.pojo.PayNoticeOk)
     */
    @Override
    public void updatePayNoticeOk(PayNoticeOk payNoticeOk) throws DataAccessException {
        Assert.notNull(payNoticeOk);
        logger.debug("updatePayNoticeOk...xunleiPayId:{}", payNoticeOk.getXunleiPayId());
        this.payNoticeOkMapper.updatePayNoticeOk(payNoticeOk);
    }
}
