/**
 * Project: dbservice
 * 
 * File Created at 2014年12月11日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.PayNoticeFailDAO;
import com.xunlei.channel.db.orm.PayNoticeFailMapper;
import com.xunlei.channel.db.pojo.PayNoticeFail;

/**
 * TODO Comment of PayNoticeFailDAOImpl
 * 
 * @author gonglijian
 */
@Service
public class PayNoticeFailDAOImpl implements PayNoticeFailDAO {
    private Logger              logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private PayNoticeFailMapper payNoticeFailMapper;

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayNoticeFailDAO#getPayNoticeFail(java.lang
     * .String)
     */
    @Override
    public PayNoticeFail getPayNoticeFail(String xunleiPayId) throws DataAccessException {
        Assert.notNull(xunleiPayId);
        logger.debug("getPayNoticeFail...xunleiPayId:{}", xunleiPayId);
        return this.payNoticeFailMapper.getPayNoticeFail(xunleiPayId);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayNoticeFailDAO#savePayNoticeFail(com.xunlei
     * .channel.db.pojo.PayNoticeFail)
     */
    @Transactional(readOnly = false)
    @Override
    public void savePayNoticeFail(PayNoticeFail payNoticeFail) throws DataAccessException {
        Assert.notNull(payNoticeFail);
        logger.debug("savePayNoticeFail...xunleiPayId:{}", payNoticeFail.getXunleiPayId());
        this.payNoticeFailMapper.savePayNoticeFail(payNoticeFail);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayNoticeFailDAO#updatePayNoticeFail(com.xunlei
     * .channel.db.pojo.PayNoticeFail)
     */
    @Override
    public void updatePayNoticeFail(PayNoticeFail payNoticeFail) throws DataAccessException {
        Assert.notNull(payNoticeFail);
        logger.debug("updatePayNoticeFail...xunleiPayId:{}", payNoticeFail.getXunleiPayId());
        this.payNoticeFailMapper.updatePayNoticeFail(payNoticeFail);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayNoticeFailDAO#getPayNoticeFailList(java.
     * util.Date, int, int)
     */
    @Override
    public List<PayNoticeFail> getPayNoticeFailList(Date noticeTime, int minFailTimes,
                                                    int maxFailTimes) throws DataAccessException {
        return this.payNoticeFailMapper
                .getPayNoticeFailList(noticeTime, minFailTimes, maxFailTimes);
    }

}
