/**
 * Project: dbservice
 * 
 * File Created at 2014年12月11日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.PartnerDAO;
import com.xunlei.channel.db.orm.PartnerMapper;
import com.xunlei.channel.db.pojo.Partner;

/**
 * TODO Comment of PartnerDAOImpl
 * 
 * @author gonglijian
 */
public class PartnerDAOImpl implements PartnerDAO {

    private Logger        logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private PartnerMapper partnerMapper;

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PartnerDAO#savePartner(com.xunlei.channel.db
     * .pojo.Partner)
     */
    @Transactional(readOnly = false)
    @Override
    public void savePartner(Partner partner) throws DataAccessException {
        Assert.notNull(partner);
        logger.debug("savePartner...name:{}", partner.getName());
        this.partnerMapper.savePartner(partner);
    }

}
