/**
 * Project: dbservice
 * 
 * File Created at 2014-12-2
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.ContactResultDAO;
import com.xunlei.channel.db.orm.ContactResultMapper;
import com.xunlei.channel.db.pojo.ContactResult;

@Service
public class ContactResultDAOImpl implements ContactResultDAO {

    private Logger              logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ContactResultMapper ContactResultMapper;

    @Transactional(readOnly = false)
    @Override
    public void saveContactResult(ContactResult contactResult) throws DataAccessException {
        ContactResultMapper.saveContactResult(contactResult);
    }

    @Override
    public ContactResult getContactResult(String xunleiId) throws DataAccessException {
        Assert.notNull(xunleiId);
        return ContactResultMapper.getContactResult(xunleiId);
    }

    @Transactional(readOnly = false)
    @Override
    public void updateContactResult(ContactResult contactResult) throws DataAccessException {
        Assert.notNull(contactResult);
        logger.debug("updateContactResult...xunleiPayId:{}", contactResult.getXunleiId());
        ContactResultMapper.updateContactResult(contactResult);
    }

}
