/**
 * Project: dbservice
 * 
 * File Created at 2014-12-2
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.ContactReqDAO;
import com.xunlei.channel.db.orm.ContactReqMapper;
import com.xunlei.channel.db.pojo.ContactReq;

@Service
public class ContactReqDAOImpl implements ContactReqDAO {

    private Logger           logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ContactReqMapper ContactReqMapper;

    @Transactional(readOnly = false)
    @Override
    public void saveContactReq(ContactReq contactReq) throws DataAccessException {
        ContactReqMapper.saveContactReq(contactReq);
    }

    @Override
    public ContactReq getContactReq(String xunleiId) throws DataAccessException {
        Assert.notNull(xunleiId);
        return ContactReqMapper.getContactReq(xunleiId);
    }

    @Transactional(readOnly = false)
    @Override
    public void updateContactReq(ContactReq contactReq) throws DataAccessException {
        Assert.notNull(contactReq);
        logger.debug("save payOrder...xunleiPayId:{}", contactReq.getXunleiId());
        ContactReqMapper.updateContactReq(contactReq);
    }

}
