/**
 * Project: dbservice
 * 
 * File Created at 2014-12-2
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.ContactPayLimitDAO;
import com.xunlei.channel.db.orm.ContactPayLimitMapper;
import com.xunlei.channel.db.pojo.ContactPayLimit;

@Service
public class ContactPayLimitDAOImpl implements ContactPayLimitDAO {

    private Logger                logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ContactPayLimitMapper ContactPayLimitMapper;

    @Transactional(readOnly = false)
    @Override
    public void saveContactPayLimit(ContactPayLimit contactPayLimit) throws DataAccessException {
        ContactPayLimitMapper.saveContactPayLimit(contactPayLimit);
    }

    @Override
    public ContactPayLimit getContactPayLimit(String xunleiId) throws DataAccessException {
        Assert.notNull(xunleiId);
        return ContactPayLimitMapper.getContactPayLimit(xunleiId);
    }

    @Transactional(readOnly = false)
    @Override
    public void updateContactPayLimit(ContactPayLimit contactPayLimit) throws DataAccessException {
        Assert.notNull(contactPayLimit);
        logger.debug("save payOrder...xunleiPayId:{}", contactPayLimit.getXunleiId());
        ContactPayLimitMapper.updateContactPayLimit(contactPayLimit);
    }

}
