package com.xunlei.channel.db.dao.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.ConfigInfoDAO;
import com.xunlei.channel.db.orm.ConfigInfoMapper;
import com.xunlei.channel.db.pojo.ConfigInfo;
@Service
public class ConfigInfoDAOImpl implements ConfigInfoDAO{
    
    private Logger                   logger = LoggerFactory.getLogger(getClass());
   
    @Autowired
    private ConfigInfoMapper configInfoMapper;

    @Transactional(readOnly = false)
    @Override
    public void saveConfigInfo(ConfigInfo configInfo) throws DataAccessException{
        configInfoMapper.saveConfigInfo(configInfo);
    }

    @Override
    public void updateConfigInfo(ConfigInfo configInfo) throws DataAccessException{
        configInfoMapper.updateConfigInfo(configInfo);
    }

    @Override
    public ConfigInfo getConfigInfo(ConfigInfo configInfo) throws DataAccessException{
        Assert.notNull(configInfo);
        return configInfoMapper.getConfigInfo(configInfo);
    }

    @Override
    public void deleteConfigInfo(ConfigInfo configInfo) throws DataAccessException{
        Assert.notNull(configInfo);
        this.configInfoMapper.deleteConfigInfo(configInfo);
    }


}
