package com.xunlei.channel.db.dao.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.ChannelAutoPayResultDAO;
import com.xunlei.channel.db.orm.ChannelAutoPayResultMapper;
import com.xunlei.channel.db.pojo.ChannelAutoPayResult;

@Service
public class ChannelAutoPayResultDAOImpl implements ChannelAutoPayResultDAO {

    private Logger                     logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ChannelAutoPayResultMapper channelAutoPayResultMapper;

    @Override
    public void saveChannelAutoPayResult(ChannelAutoPayResult channelAutoPayResult)
            throws DataAccessException {
        channelAutoPayResultMapper.saveChannelAutoPayResult(channelAutoPayResult);
    }

    @Override
    public ChannelAutoPayResult getChannelAutoPayResult(String xunleiPayId)
            throws DataAccessException {
        Assert.notNull(xunleiPayId);
        return channelAutoPayResultMapper.getChannelAutoPayResult(xunleiPayId);
    }

    @Override
    public void updateChannelAutoPayResult(ChannelAutoPayResult channelAutoPayResult)
            throws DataAccessException {
        Assert.notNull(channelAutoPayResult);
        logger.debug("save payOrder...xunleiPayId:{}", channelAutoPayResult.getXunleiId());
        channelAutoPayResultMapper.updateChannelAutoPayResult(channelAutoPayResult);
    }

}
