/**
 * Project: dbservice
 * 
 * File Created at 2014-12-2
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.BizDAO;
import com.xunlei.channel.db.orm.BizMapper;
import com.xunlei.channel.db.pojo.Biz;

/**
 * @author gonglijian
 */
@Service
public class BizDAOImpl implements BizDAO {
    private Logger    logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private BizMapper bizMapper;

    @Override
    public List<Biz> listAllBizs() throws DataAccessException {
        return this.bizMapper.listAllBizs();
    }

    @Override
    @Transactional(readOnly = false)
    public void saveBiz(Biz biz) throws DataAccessException {
        Assert.notNull(biz);
        logger.debug("save biz...bizNo:{},bizName:{}", biz.getBizNo(), biz.getBizName());
        this.bizMapper.saveBiz(biz);
    }

    @Override
    public Biz getBiz(String bizNo) throws DataAccessException {
        Assert.notNull(bizNo);
        return this.bizMapper.getBiz(bizNo);
    }
}
