/**
 * Project: dbservice
 * 
 * File Created at 2014-12-1
 * laiquan.luolq
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao;

import java.util.Date;
import java.util.List;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.db.pojo.PayOrderOk;

/**
 * TODO Comment of IPayOrderDAO
 * 
 * @author lishaojun
 */
public interface PayOrderOkDAO {

    /**
     * 保存请求订单信息到数据库
     * 
     * @param biz
     * @throws DataAccessException
     */
    void savePayOrderOk(PayOrderOk payOrderOk) throws DataAccessException;

    /**
     * 更新请求订单
     * 
     * @param payOrderOk
     */
    void updatePayOrderOk(PayOrderOk payOrderOk) throws DataAccessException;

    /**
     * 通过xunleiPayId获得请求订单的实体
     * 
     * @param xunleiPayId
     * @return PayOrder
     * @throws DataAccessException
     */
    PayOrderOk getPayOrderOk(String xunleiPayId) throws DataAccessException;

    /**
     * @param bizNo
     * @param bizOrderId
     * @return
     */
    PayOrderOk getPayOrderOkByBizNoAndBizOrderId(String bizNo, String bizOrderId)
            throws DataAccessException;

    /**
     * 得到成功订单表里的send_notice_status值
     * 
     * @param xunleiPayId
     * @return send_notice_status值
     */
    String getPayOrderOkSendNoticeStatus(String xunleiPayId) throws DataAccessException;

    /**
     * 更新send_notice_status值
     * 
     * @param xunleiPayId
     * @param sendNoticeStatus
     */
    void updateSendNoticeStatus(String xunleiPayId, String sendNoticeStatus)
            throws DataAccessException;

    /**
     * @param fromTime
     * @param endTime
     * @return
     */
    List<String> listUnsuccessNoticeXunleiPayId(Date fromTime, Date endTime)
            throws DataAccessException;

}
