/**
 * Project: dbservice
 * 
 * File Created at 2014-12-1
 * laiquan.luolq
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.db.pojo.PayOrderFail;

/**
 * TODO Comment of IPayOrderDAO
 * 
 * @author laiquan.luolq
 */
public interface PayOrderFailDAO {

    /**
     * 保存请求订单信息到数据库
     * 
     * @param biz
     * @throws DataAccessException
     */
    void savePayOrderFail(PayOrderFail payOrderFail) throws DataAccessException;

    /**
     * 更新请求订单
     * 
     * @param payOrderFail
     */
    void updatePayOrderFail(PayOrderFail payOrderFail) throws DataAccessException;

    /**
     * 通过xunleiPayId获得请求订单的实体
     * 
     * @param xunleiPayId
     * @return PayOrder
     * @throws DataAccessException
     */
    PayOrderFail getPayOrderFail(String xunleiPayId) throws DataAccessException;

}
