/**
 * Project: dbservice
 * 
 * File Created at 2014-12-1
 * laiquan.luolq
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.db.pojo.PayOrder;

/**
 * TODO Comment of IPayOrderDAO
 * 
 * @author laiquan.luolq
 */
public interface PayOrderDAO {

    /**
     * 保存请求订单信息到数据库
     * 
     * @param biz
     * @throws DataAccessException
     */
    void savePayOrder(PayOrder payOrder) throws DataAccessException;

    /**
     * 通过xunleiPayId获得请求订单的实体
     * 
     * @param xunleiPayId
     * @return PayOrder
     * @throws DataAccessException
     */
    PayOrder getPayOrder(String xunleiPayId) throws DataAccessException;

    /**
     * @param bizNo
     * @param bizOrderId
     * @return
     */
    PayOrder getPayOrderByBizNoAndBizOrderId(String bizNo, String bizOrderId)
            throws DataAccessException;

    /**
     * @param bizNo
     * @param bizOrderId
     * @return
     */
    int getCountByBizNoAndBizOrderId(String bizNo, String bizOrderId) throws DataAccessException;

    /**
     * 更新请求订单的支付状态和渠道支付号
     * 
     * @param xunleiPayId
     * @param channelOrderId
     * @param orderStatus
     */
    void updatePayOrderStatusAndChannelId(String xunleiPayId, String orderStatus,
                                          String channelOrderId) throws DataAccessException;

}
