/**
 * Project: dbservice
 * 
 * File Created at 2014年12月11日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao;

import java.util.Date;
import java.util.List;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.db.pojo.PayNoticeFail;

/**
 * TODO Comment of PayNoticeFailDAO
 * 
 * @author gonglijian
 */
public interface PayNoticeFailDAO {

    /**
     * @param xunleiPayId
     * @return
     */
    PayNoticeFail getPayNoticeFail(String xunleiPayId) throws DataAccessException;

    /**
     * @param payNoticeFail
     */
    void savePayNoticeFail(PayNoticeFail payNoticeFail) throws DataAccessException;

    /**
     * @param payNoticeFail
     */
    void updatePayNoticeFail(PayNoticeFail payNoticeFail) throws DataAccessException;

    /**
     * @param noticeTime
     * @param minFailTimes
     * @param maxFailTimes
     * @return
     */
    List<PayNoticeFail> getPayNoticeFailList(Date noticeTime, int minFailTimes, int maxFailTimes)
            throws DataAccessException;

}
