package com.xunlei.channel.db.dao;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.db.pojo.ContactResult;

public interface ContactResultDAO {
    /**
     * 保存到签约表
     * 
     * @param ContactResult
     */
    void saveContactResult(ContactResult contactResult) throws DataAccessException;

    /**
     * 更新签约表
     * 
     * @param payOrder
     */
    void updateContactResult(ContactResult contactResult) throws DataAccessException;

    /**
     * 通过迅雷Id来查找签约表信息
     * 
     * @param xunleiId
     * @return ContactResult or null
     */
    ContactResult getContactResult(String xunleiId) throws DataAccessException;

}
