/**
 * Project: dbservice
 * 
 * File Created at 2014-12-2
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.common;

/**
 * 相关常量
 * 
 * @author laiquan.luolq
 */
public interface Constants {
    /**
     * 下单失败
     */
    public static final String ORDER_FAIL                             = "N";
    /**
     * 下单成功
     */
    public static final String ORDER_SUCCESS                          = "Y";
    /**
     * 发送通知成功
     */
    public static final String SEND_NOTICE_STATUS_OK                  = "S";
    /**
     * 发送通知失败
     */
    public static final String SEND_NOTICE_STATUS_FAIL                = "F";

    /**
     * A：支付订单；
     */
    public static final String ORDER_TYPE_PAY                         = "A";
    /**
     * B：包月订单；
     */
    public static final String ORDER_TYPE_MONTHLY                     = "B";
    /**
     * C：自动续费订单；
     */
    public static final String ORDER_TYPE_RENEW                       = "C";
    /**
     * D：退款订单；
     */
    public static final String ORDER_TYPE_REFUND                      = "D";
    /**
     * E：批量付款
     */
    public static final String ORDER_TYPE_BATCH                       = "E";

    /**
     * 订单支付状态：等待
     */
    public static final String ORDER_STATUS_WAIT                      = "W";
    /**
     * 订单支付状态：成功
     */
    public static final String ORDER_STATUS_SUCCESS                   = "S";
    /**
     * 订单支付状态：失败
     */
    public static final String ORDER_STATUS_FAIL                      = "F";

    /**
     * 签约
     */
    public static final String CONTACT_TYPE_QIANYUE                   = "QY";
    /**
     * 解约
     */
    public static final String CONTACT_TYPE_JIEYUE                    = "JY";

    /**
     * 签约状态：成功
     */
    public static final String CONTACT_STATUS_SUCCESS                 = "Y";
    /**
     * 签约状态：失败
     */
    public static final String CONTACT_STATUS_FAIL                    = "N";

    /**
     * 消费限额类型：每次
     */
    public static final String CONTACT_LIMIT_TYPE_ONCE                = "A";
    /**
     * 消费限额类型：每周
     */
    public static final String CONTACT_LIMIT_TYPE_WEEKLY              = "B";
    /**
     * 消费限额类型：每月
     */
    public static final String CONTACT_LIMIT_TYPE_MONTHLY             = "C";

    /**
     * 业务方续费类型：续费
     */
    public static final String BIZ_AUTO_PAY_TYPE_XUFEI                = "Y";
    /**
     * 业务方续费类型：取消续费
     */
    public static final String BIZ_AUTO_PAY_TYPE_CANCEL               = "N";

    /**
     * 业务方续费请求来源：用户
     */
    public static final String BIZ_AUTO_PAY_REQ_FROM_USER             = "U";
    /**
     * 业务方续费请求来源：系统
     */
    public static final String BIZ_AUTO_PAY_REQ_FROM_SYSTEM           = "S";

    /**
     * 业务方续费状态：成功
     */
    public static final String BIZ_AUTO_PAY_STATUS_SUCCESS            = "S";
    /**
     * 业务方续费状态：失败
     */
    public static final String BIZ_AUTO_PAY_STATUS_FAIL               = "F";

    /**
     * 包月续费结果表的周期：日
     */
    public static final String CHANNEL_AUTO_PAY_RESULT_PERIOD_DAILY   = "D";
    /**
     * 包月续费结果表的周期：日
     */
    public static final String CHANNEL_AUTO_PAY_RESULT_PERIOD_WEEKLY  = "W";
    /**
     * 包月续费结果表的周期：日
     */
    public static final String CHANNEL_AUTO_PAY_RESULT_PERIOD_MONTHLY = "M";
    /**
     * 包月续费结果表的周期：日
     */
    public static final String CHANNEL_AUTO_PAY_RESULT_PERIOD_YEARLY  = "Y";

    /**
     * 包月续费退订状态：等待
     */
    public static final String CHANNEL_AUTO_PAY_QUIT_STATUS_WAIT      = "W";
    /**
     * 包月续费退订状态：成功
     */
    public static final String CHANNEL_AUTO_PAY_QUIT_STATUS_SUCCESS   = "S";
    /**
     * 包月续费退订状态：失败
     */
    public static final String CHANNEL_AUTO_PAY_QUIT_STATUS_FAIL      = "F";

    /**
     * 产品的状态：可用
     */
    public static final String PRODUCT_STATUS_ACTIVE                  = "Y";
    /**
     * 产品的状态：不可用
     */
    public static final String PRODUCT_STATUS_INACTIVE                = "N";
    /**
     * PARTNER的状态：可用
     */
    public static final String PARTNER_STATUS_ACTIVE                  = "Y";
    /**
     * PARTNER的状态：不可用
     */
    public static final String PARTNER_STATUS_INACTIVE                = "N";

    /**
     * BIZ的状态：可用
     */
    public static final String BIZ_STATUS_ACTIVE                      = "Y";
    /**
     * BIZ的状态：不可用
     */
    public static final String BIZ_STATUS_INACTIVE                    = "N";

    public static final String ORDER_PAGE_CHARSET_UTF8                = "A";

    public static final String ORDER_PAGE_CHARSET_GBK                 = "B";

    /**
     * pay_notice_fail的status的值
     */
    public static final String PAY_NOTICE_STATUS_SUCCESS              = "S";
    /**
     * pay_notice_fail的status的值
     */
    public static final String PAY_NOTICE_STATUS_FAIL                 = "F";

}
