package com.xunlei.channel.db.pojo;

/**
 * 抽象出请求订单和成功订单共有的属性
 * 
 * @author gonglijian
 */
public abstract class AbstractOrder extends AbstractBaseEntity {

    /**
	 * 
	 */
    private static final long serialVersionUID = -3544307369029182775L;
    /**
     * 对外接口版本号，发送订单通知的时候可能会用到
     */
    private String            version;
    /**
     * 编码，回调通知用到,跟对外接口定义的一致
     */
    private int               inputCharset;
    /**
     * 后台通知接口
     */
    private String            notifyUrl;
    /**
     * 页面通知接口,支付成功后页面会转到这个页面,这是很可能用到pageCharset
     */
    private String            pageUrl;
    /**
     * 支付网关唯一订单号
     */
    private String            xunleiPayId;
    /**
     * 业务方ID
     */
    private String            bizNo;
    /**
     * 业务方订单号，业务方唯一
     */
    private String            bizOrderId;
    /**
     * 支付类型
     */
    private String            payType;

    /**
     * 订单金额，分为单位
     */
    private Integer           orderAmt;
    /**
     * 这个是业务方传过来的订单时间,yyyyMMddHHmmss
     */
    private String            orderTime;
    /**
     * 订单组别，批量付款会用到
     */
    private String            orderGroup;
    /**
     * 渠道订单号,唯一标识一个订单
     */
    private String            channelOrderId;
    // 迅雷ID
    private String            xunleiId;
    // 迅雷昵称，要不要留着？
    private String            userShow;

    @Deprecated
    private String            peerId;

    /**
     * 商品ID
     */
    private Long              productId;
    /**
     * 商品名称
     */
    private String            productName;
    /**
     * 商品描述
     */
    private String            productDesc;
    /**
     * 支付人手机号
     */
    private String            phone;
    /**
     * 给业务方的扩展字段,发送订单通知的时候会返回回去
     */
    private String            extraCommonParam;
    /**
     * 下订单的用户IP
     */
    private String            clientIp;

    private String            extraJson;
    // A：支付订单；B：包月订单；C：自动续费订单；D：退款订单；E：批量付款
    private String            orderType;

    /**
     * @return the version
     */
    public String getVersion() {
        return version;
    }

    /**
     * @param version the version to set
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * @return the inputCharset
     */
    public int getInputCharset() {
        return inputCharset;
    }

    /**
     * @param inputCharset the inputCharset to set
     */
    public void setInputCharset(int inputCharset) {
        this.inputCharset = inputCharset;
    }

    /**
     * @return the notifyUrl
     */
    public String getNotifyUrl() {
        return notifyUrl;
    }

    /**
     * @param notifyUrl the notifyUrl to set
     */
    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    /**
     * @return the pageUrl
     */
    public String getPageUrl() {
        return pageUrl;
    }

    /**
     * @param pageUrl the pageUrl to set
     */
    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    /**
     * @return the xunleiPayId
     */
    public String getXunleiPayId() {
        return xunleiPayId;
    }

    /**
     * @param xunleiPayId the xunleiPayId to set
     */
    public void setXunleiPayId(String xunleiPayId) {
        this.xunleiPayId = xunleiPayId;
    }

    /**
     * @return the bizNo
     */
    public String getBizNo() {
        return bizNo;
    }

    /**
     * @param bizNo the bizNo to set
     */
    public void setBizNo(String bizNo) {
        this.bizNo = bizNo;
    }

    /**
     * @return the bizOrderId
     */
    public String getBizOrderId() {
        return bizOrderId;
    }

    /**
     * @param bizOrderId the bizOrderId to set
     */
    public void setBizOrderId(String bizOrderId) {
        this.bizOrderId = bizOrderId;
    }

    /**
     * @return the payType
     */
    public String getPayType() {
        return payType;
    }

    /**
     * @param payType the payType to set
     */
    public void setPayType(String payType) {
        this.payType = payType;
    }

    /**
     * @return the orderAmt
     */
    public Integer getOrderAmt() {
        return orderAmt;
    }

    /**
     * @param orderAmt the orderAmt to set
     */
    public void setOrderAmt(Integer orderAmt) {
        this.orderAmt = orderAmt;
    }

    /**
     * @return the orderTime
     */
    public String getOrderTime() {
        return orderTime;
    }

    /**
     * @param orderTime the orderTime to set
     */
    public void setOrderTime(String orderTime) {
        this.orderTime = orderTime;
    }

    /**
     * @return the orderGroup
     */
    public String getOrderGroup() {
        return orderGroup;
    }

    /**
     * @param orderGroup the orderGroup to set
     */
    public void setOrderGroup(String orderGroup) {
        this.orderGroup = orderGroup;
    }

    /**
     * @return the channelOrderId
     */
    public String getChannelOrderId() {
        return channelOrderId;
    }

    /**
     * @param channelOrderId the channelOrderId to set
     */
    public void setChannelOrderId(String channelOrderId) {
        this.channelOrderId = channelOrderId;
    }

    /**
     * @return the xunleiId
     */
    public String getXunleiId() {
        return xunleiId;
    }

    /**
     * @param xunleiId the xunleiId to set
     */
    public void setXunleiId(String xunleiId) {
        this.xunleiId = xunleiId;
    }

    /**
     * @return the userShow
     */
    public String getUserShow() {
        return userShow;
    }

    /**
     * @param userShow the userShow to set
     */
    public void setUserShow(String userShow) {
        this.userShow = userShow;
    }

    /**
     * @return the peerId
     */
    public String getPeerId() {
        return peerId;
    }

    /**
     * @param peerId the peerId to set
     */
    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    /**
     * @return the productId
     */
    public Long getProductId() {
        return productId;
    }

    /**
     * @param productId the productId to set
     */
    public void setProductId(Long productId) {
        this.productId = productId;
    }

    /**
     * @return the productName
     */
    public String getProductName() {
        return productName;
    }

    /**
     * @param productName the productName to set
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * @return the productDesc
     */
    public String getProductDesc() {
        return productDesc;
    }

    /**
     * @param productDesc the productDesc to set
     */
    public void setProductDesc(String productDesc) {
        this.productDesc = productDesc;
    }

    /**
     * @return the phone
     */
    public String getPhone() {
        return phone;
    }

    /**
     * @param phone the phone to set
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    /**
     * @return the extraCommonParam
     */
    public String getExtraCommonParam() {
        return extraCommonParam;
    }

    /**
     * @param extraCommonParam the extraCommonParam to set
     */
    public void setExtraCommonParam(String extraCommonParam) {
        this.extraCommonParam = extraCommonParam;
    }

    /**
     * @return the clientIp
     */
    public String getClientIp() {
        return clientIp;
    }

    /**
     * @param clientIp the clientIp to set
     */
    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    /**
     * @return the extraJson
     */
    public String getExtraJson() {
        return extraJson;
    }

    /**
     * @param extraJson the extraJson to set
     */
    public void setExtraJson(String extraJson) {
        this.extraJson = extraJson;
    }

    /**
     * @return the orderType
     */
    public String getOrderType() {
        return orderType;
    }

    /**
     * @param orderType the orderType to set
     */
    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

}
