/**
 * 
 */
package com.xunlei.channel.db.orm;

import java.util.List;

import com.xunlei.channel.db.pojo.Biz;

/**
 * @author gonglijian
 */
public interface BizMapper {

    /**
     * 得到所有的业务方信息
     * 
     * @return List of Biz
     */
    List<Biz> listAllBizs();

    /**
     * 保存业务方信息到数据库
     * 
     * @param biz
     */
    void saveBiz(Biz biz);

    /**
     * 通过bizNo得到业务方信息
     * 
     * @param bizNo 唯一业务号
     * @return Biz or null
     */
    Biz getBiz(String bizNo);

}
