/**
 * 
 */
package com.xunlei.channel.db.dao.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.IBizDAO;
import com.xunlei.channel.db.orm.BizMapper;
import com.xunlei.channel.db.orm.PayOrderMapper;
import com.xunlei.channel.db.orm.PayOrderOkMapper;
import com.xunlei.channel.db.pojo.Biz;

/**
 * @author gonglijian
 */
@Service
public class BizDAOImpl implements IBizDAO {
    private Logger           logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private PayOrderMapper   payOrderMapper;
    @Autowired
    private PayOrderOkMapper payOrderOkMapper;
    @Autowired
    private BizMapper        bizMapper;

    @Override
    public List<Biz> listAllBizs() throws DataAccessException {
        return this.bizMapper.listAllBizs();
    }

    @Override
    @Transactional(readOnly = false)
    public void saveBiz(Biz biz) throws DataAccessException {
        Assert.notNull(biz);
        logger.debug("save biz...bizNo:{},bizName:{}", biz.getBizNo(), biz.getBizName());
        this.bizMapper.saveBiz(biz);
    }

    @Override
    public Biz getBiz(String bizNo) throws DataAccessException {
        Assert.notNull(bizNo);
        return this.bizMapper.getBiz(bizNo);
    }
}
