/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.db.task.dao.impl;

import com.xunlei.channel.db.task.dao.TaskStatisticDAO;
import com.xunlei.channel.db.task.mapper.TaskStatisticMapper;
import com.xunlei.channel.db.task.pojo.TaskStatistic;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskStatisticDAOImpl
implements TaskStatisticDAO {
    private static final Logger logger = LoggerFactory.getLogger(TaskStatisticDAOImpl.class);
    @Resource
    private TaskStatisticMapper taskStatisticMapper;

    @Override
    public void increaseStatistic(String taskNo, String balanceDate, int result) {
        logger.info("increaseStatistic...taskNo:{},balanceDate:{},result:{}", new Object[]{taskNo, balanceDate, result});
        TaskStatistic statistic = this.getTaskStatistic(taskNo, balanceDate);
        if (null == statistic) {
            statistic = new TaskStatistic();
            statistic.setBalanceDate(balanceDate);
            statistic.setTaskNo(taskNo);
        }
        if (result == 1) {
            statistic.increaseSuccessCount();
        } else {
            statistic.increaseFailCount();
        }
        this.taskStatisticMapper.addTaskStatistic(statistic);
    }

    @Transactional(readOnly=false)
    private void saveTaskStatistic(TaskStatistic statistic) {
        this.taskStatisticMapper.addTaskStatistic(statistic);
    }

    private TaskStatistic getTaskStatistic(String taskNo, String balanceDate) {
        return this.taskStatisticMapper.getTaskStatistic(taskNo, balanceDate);
    }

    @Override
    public List<TaskStatistic> listTaskStatistic(String startDate, String endDate) {
        return this.taskStatisticMapper.getAllTaskStatistic(startDate, endDate);
    }
}

