/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.db.task.dao.impl;

import com.xunlei.channel.db.task.dao.TaskStatisticDAO;
import com.xunlei.channel.db.task.orm.TaskStatisticMapper;
import com.xunlei.channel.db.task.pojo.TaskStatistic;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskStatisticDAOImpl
implements TaskStatisticDAO {
    private static final Logger logger = LoggerFactory.getLogger(TaskStatisticDAOImpl.class);
    @Autowired
    private TaskStatisticMapper taskStatisticMapper;

    @Override
    public void increaseStatistic(String taskNo, String balanceDate, boolean isOk) {
        logger.info("increaseStatistic...taskNo:{},balanceDate:{},isOk:{}", new Object[]{taskNo, balanceDate, isOk});
        TaskStatistic statistic = this.getTaskStatistic(taskNo, balanceDate);
        if (null == statistic) {
            statistic = new TaskStatistic();
            statistic.setBalanceDate(balanceDate);
            statistic.setTaskNo(taskNo);
        }
        if (isOk) {
            statistic.increaseSuccessCount();
        } else {
            statistic.increaseFailCount();
        }
        if (null == statistic.getId()) {
            this.saveTaskStatistic(statistic);
        } else {
            this.updateTaskStatistic(statistic);
        }
    }

    @Transactional(readOnly=false)
    private void updateTaskStatistic(TaskStatistic statistic) {
        this.taskStatisticMapper.updateTaskStatistic(statistic);
    }

    @Transactional(readOnly=false)
    private void saveTaskStatistic(TaskStatistic statistic) {
        this.taskStatisticMapper.saveTaskStatistic(statistic);
    }

    private TaskStatistic getTaskStatistic(String taskNo, String balanceDate) {
        return this.taskStatisticMapper.getTaskStatistic(taskNo, balanceDate);
    }

    @Override
    public List<TaskStatistic> listTaskStatistic(String startDate, String endDate) {
        return this.taskStatisticMapper.listTaskStatistic(startDate, endDate);
    }
}

