package com.xunlei.channel.common.platform.util;

import com.xunlei.channel.common.platform.constants.ResultCodeConstants;
import com.xunlei.channel.common.platform.entity.ReturnResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

import java.util.Iterator;
import java.util.List;

/**
 * @author xiongyingqi
 * @since 16-11-16 下午4:13
 */
public abstract class BindingResultUtils {
    public static ReturnResult buildResult(BindingResult bindingResult) {
        if (!bindingResult.hasErrors()) {
            return null;
        }

        ReturnResult returnResult = new ReturnResult();
        returnResult.setCode(ResultCodeConstants.CODE_PARAMS_ERROR);
        returnResult.setMessage("PARAMS_ERROR");
        StringBuilder builder = new StringBuilder();
        List<ObjectError> allErrors = bindingResult.getAllErrors();
        for (Iterator<ObjectError> iterator = allErrors.iterator(); iterator.hasNext(); ) {
            ObjectError error = iterator.next();
            if (!(error instanceof FieldError)) {
                continue;
            }
            FieldError fieldError = (FieldError) error;
            String field = fieldError.getField();
            String defaultMessage = fieldError.getDefaultMessage();
            builder.append(field);
            builder.append(" ");
            builder.append(defaultMessage);
            if (iterator.hasNext()) {
                builder.append(";");
            }
        }
        returnResult.setDescribe(builder.toString());
        return returnResult;
    }
}
