/**
 * Project: gateway-interface
 * File Created at 2016年5月3日
 * gonglijian
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.common.platform.spring.exception;

import com.xunlei.channel.common.platform.entity.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 异常统一处理类，根据前端请求的需要，返回XML|JSON|或者网页格式
 *
 * @author xiongyingqi
 */
public class InterfaceExceptionHandler extends AbstractHandlerExceptionResolver {

    private static final Logger logger = LoggerFactory
            .getLogger(InterfaceExceptionHandler.class);

    private static final String ACCEPT = "Accept";

    //异常jsp页面
    private static final String EXCEPTION_JSP_PATH = "exception";

    /*
     * (non-Javadoc)
     * @see
     * org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver#
     * doResolveException(javax.servlet.http.HttpServletRequest,
     * javax.servlet.http.HttpServletResponse, java.lang.Object,
     * java.lang.Exception)
     */
    @Override
    protected ModelAndView doResolveException(HttpServletRequest request,
                                              HttpServletResponse response, Object handler,
                                              Exception ex) {
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        //根据accept返回需要的数据格式
        String accept = request.getHeader(ACCEPT);
        ReturnResult result = ReturnResult.SYSTEM_ERROR;
        if (logger.isDebugEnabled()) {
            logger.debug("get Accept:{}", accept);
        }
        logger.error("Exception occurs from " + handler, ex);
        if (MediaType.TEXT_HTML_VALUE.equals(accept)
                || MediaType.APPLICATION_XHTML_XML_VALUE.equals(accept)) { //html
            ModelAndView modelAndView = new ModelAndView(EXCEPTION_JSP_PATH);
            return modelAndView;
        }

        ModelAndView modelAndView = new ModelAndView();
        if (MediaType.APPLICATION_JSON_VALUE.equals(accept)) {//JSON
            modelAndView.setView(new MappingJackson2JsonView());
        } else {
            // 默认返回XML
            modelAndView.setView(new MappingJackson2JsonView());
        }
        modelAndView.addObject(result);
        return modelAndView;
    }

}
