package com.xunlei.channel.common.platform.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xunlei.channel.common.platform.constants.ResultCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author xiongyingqi
 * @since 20171013//
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ReturnResult {
    /**
     * 成功
     */
    public static final ReturnResult SUCCESS = new ReturnResult(
            ResultCodeConstants.CODE_SUCCESS, "SUCCESS", "成功");
    /**
     * 系统错误
     */
    public static final ReturnResult SYSTEM_ERROR = new ReturnResult(
            ResultCodeConstants.CODE_SYSTEM_ERROR, "SYSTEM_ERROR", "系统错误");
    /**
     * 验证签名错误
     */
    public static final ReturnResult CHECK_SIGN_ERROR = new ReturnResult(
            ResultCodeConstants.CODE_CHECK_SIGN_ERROR, "CHECK_SIGN_ERROR", "验证签名失败！");


    @ApiModelProperty(value = "响应码", allowableValues = "range[0, infinity]")
    private Integer code;
    @ApiModelProperty(value = "响应信息")
    private String message;
    @ApiModelProperty(value = "响应描述")
    private String describe;

    @JsonIgnore
    public boolean isSuccess() {
        return isSuccess(this);
    }

    public static boolean isSuccess(int code) {
        return code == SUCCESS.code;
    }

    public static boolean isSuccess(ReturnResult resultCode) {
        return resultCode != null && SUCCESS.code.equals(resultCode.code);
    }
}
