package com.xunlei.channel.common.platform.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author xiongyingqi
 * @since 20171012//
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ResponseResult<T> extends ReturnResult {
    @ApiModelProperty("响应成功时，返回对象")
    private T resultInfo;

    public ResponseResult(Integer code, String message, String describe, T resultInfo) {
        super(code, message, describe);
        this.resultInfo = resultInfo;
    }

    public ResponseResult(Integer code, String message, String describe) {
        super(code, message, describe);
    }

    public ResponseResult() {
    }

    public static <T> ResponseResult<T> newResult(T t) {
        ResponseResult<T> response = new ResponseResult<T>(SUCCESS.getCode(), SUCCESS.getMessage(),
                SUCCESS.getDescribe());
        response.setResultInfo(t);
        return response;
    }
}
