package com.xunlei.channel.common.logic.handle;

import com.xunlei.channel.common.logic.config.constants.LogicalOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author xiongyingqi
 * @since 20171019//
 */
public abstract class LogicOperation {
    private static final Logger logger = LoggerFactory.getLogger(LogicOperation.class);

    public static boolean execute(LogicalOperation logicalOperation, boolean... result) throws HandlerException {
        if (result == null || result.length == 0) {
            return false;
        }
        switch (logicalOperation) {
            case NOT:
                return !execute(LogicalOperation.AND, result);
            case AND:
                for (boolean flag : result) {
                    if (!flag) {
                        return false;
                    }
                }
                return true;
            case OR:
                for (boolean flag : result) {
                    if (flag) {
                        return true;
                    }
                }
                return false;
            case XOR:
                if (result.length == 1) {
                    return result[0];
                }
                boolean flag = result[0] ^ result[1];
                if (result.length >= 3) {
                    for (int i = 2; i < result.length; i++) {
                        flag ^= result[i];
                    }
                }
                return flag;
            case XNOR:
                if (result.length == 1) {
                    return result[0];
                }
                boolean flag2 = (result[0] == result[1]);
                if (result.length >= 3) {
                    for (int i = 2; i < result.length; i++) {
                        flag2 = (result[0] == result[i]);
                        if (!flag2) {
                            return false;
                        }
                    }
                }
                return flag2;
            default:
                logger.error("Unknown operation: {} for result: {}", logicalOperation, result);
                throw new HandlerException("Unsupport logic operation: " + logicalOperation);
        }
    }
}
