package com.xunlei.channel.common.logic.handle;

import com.xunlei.channel.common.logic.config.method.MethodManager;
import com.xunlei.channel.common.logic.config.vo.Conditions;
import com.xunlei.channel.common.logic.vo.InputData;

/**
 * @author xiongyingqi
 * @since 20171019//
 */
public interface LogicHandler<T> {
    /**
     * 根据配置进行逻辑运算
     * @param inputData 输入对象
     * @param conditions 配置
     * @param methodManager 方法管理
     * @return 返回计算结果. <b>注意<b/>：如果最上层的conditions的<b>available<b/>为<b>false<b/>,那么计算结果也为<b>false<b/>
     * @throws HandlerException
     */
    boolean handle(T inputData, Conditions conditions, MethodManager methodManager) throws HandlerException;
}
