package com.xunlei.channel.common.logic.config.method.impl;

import com.xunlei.channel.common.logic.config.annotation.ConvertMethodName;
import com.xunlei.channel.common.logic.config.method.ConvertException;
import com.xunlei.channel.common.logic.config.method.ConvertMethod;
import com.xunlei.channel.common.logic.config.vo.Condition;
import com.xunlei.channel.common.utils.arith.Arith;

import java.math.BigDecimal;

/**
 * 取余方法
 *
 * @author xiongyingqi
 * @since 20171019//
 */
@ConvertMethodName("remainder")
public class RemainderMethod implements ConvertMethod {
    @Override
    public String execute(String fieldValue, Condition condition) throws ConvertException {
        if (fieldValue == null) {
            return null;
        }

        try {
            BigDecimal value = new BigDecimal(fieldValue);
            BigDecimal remainder = value.remainder(new BigDecimal(10));
            return remainder.toString();
        } catch (Exception e) {
            throw new ConvertException("Error when convert value: " + fieldValue + " cause: " + e.getMessage(), e);
        }
    }
}
