package com.xunlei.channel.common.logic.handle;

import com.xunlei.channel.common.logic.handle.constants.ConditionFieldType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

/**
 * 每个field对应的中间存储
 * @author xiongyingqi
 * @since 20171019//
 */
@Data
@EqualsAndHashCode(exclude = {"field", "method"})
@ToString
@AllArgsConstructor
public class ConditionFieldEntry {
    /**
     * 该字段不为空。当method不为空时(此时，ConditionFieldType=METHOD)，处理器不会从该字段取field的值；当ConditionFieldType=FIELD时，逻辑处理器会从该字段取值
     */
    private Field field;
    /**
     * 取值的方法
     */
    private Method method;
    /**
     * 字段的最终名称（对应condition里面的name）
     * @see com.xunlei.channel.common.logic.config.vo.Condition#name
     */
    private String name;
    private ConditionFieldType conditionFieldType;
}
