package com.xunlei.channel.common.logic.config.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xunlei.channel.common.logic.config.constants.LogicalOperation;
import com.xunlei.channel.common.utils.JacksonHelper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author xiongyingqi
 * @since 20171018//
 */
@Data
@EqualsAndHashCode
@ToString
public class Conditions {
    /**
     * 条件1，集合内的所有条件都必须满足该集合成为true
     */
    private List<Condition> conditions;
    /**
     * 条件2
     */
    private Conditions subConditions;
    /**
     * 条件1和条件2的逻辑运算
     */
    private LogicalOperation logicalOperation;
    /**
     * 当前条件是否可用，如果available=false,那么当前对象的结果是<b>false</b>
     */
    private boolean available = true;

    public void addCondition(Condition condition) {
        if (conditions == null) {
            synchronized (this) {
                List<Condition> conditionsTmp = new ArrayList<Condition>();
                if (this.conditions != null) {
                    conditionsTmp.addAll(this.conditions);
                }
                this.conditions = conditionsTmp;
            }
        }
        conditions.add(condition);
    }

    @JsonIgnore
    public String toJsonString() {
        return JacksonHelper.getJsonString(this);
    }

    @JsonIgnore
    public static Conditions fromJsonString(String json) throws IOException {
        Conditions conditions = JacksonHelper.convertJsonByClass(json, Conditions.class);
        return conditions;
    }

}
