package com.xunlei.channel.common.logic.config.vo;

import com.xunlei.channel.common.logic.config.constants.FieldQualified;
import com.xunlei.channel.common.utils.CollectionUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

/**
 *
 * @author xiongyingqi
 * @since 20171017//
 */
@Data
@ToString
@EqualsAndHashCode
public class Condition {
    /**
     * 配置值的分隔符（如果包含多个值）
     */
    public static final String VALUES_DELIMITER = ",";
    /**
     * 字段名称
     */
    private String name;
    /**
     * 配置值，多个配置值用逗号分隔
     */
    private String value;
    private FieldQualified qualified;
    private String valueConvertMethod;
    private boolean available = true;

    public static Collection<String> splitConfigValue(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        String[] split = value.split(VALUES_DELIMITER);
        return Arrays.asList(split);
    }

}
