package com.xunlei.channel.common.logic.config.constants;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author xiongyingqi
 * @since 20171017//
 */
@JsonFormat
public enum FieldQualified {
    /**
     * 判断传入的值是否等于配置内容
     */
    EQUALS("equals"),
    /**
     * 判断传入的值是否在配置内容内
     */
    IN("in"),
    /**
     * 判断传入的值是否包含配置内容
     */
    CONTAINS("contains");

    private String name;

    FieldQualified(String name) {
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

}
