/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.logic.handle.impl;

import com.xunlei.channel.common.logic.config.constants.FieldQualified;
import com.xunlei.channel.common.logic.config.constants.LogicalOperation;
import com.xunlei.channel.common.logic.config.method.ConvertException;
import com.xunlei.channel.common.logic.config.method.ConvertMethod;
import com.xunlei.channel.common.logic.config.method.MethodManager;
import com.xunlei.channel.common.logic.config.vo.Condition;
import com.xunlei.channel.common.logic.config.vo.Conditions;
import com.xunlei.channel.common.logic.handle.ConditionFieldHandler;
import com.xunlei.channel.common.logic.handle.HandlerException;
import com.xunlei.channel.common.logic.handle.LogicHandler;
import com.xunlei.channel.common.logic.handle.LogicOperation;
import com.xunlei.channel.common.utils.Assert;
import com.xunlei.channel.common.utils.CollectionUtils;
import com.xunlei.channel.common.utils.string.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicHandlerImpl
implements LogicHandler {
    private static final Logger logger = LoggerFactory.getLogger(LogicHandlerImpl.class);

    @Override
    public boolean handle(Object object, Conditions conditions, MethodManager methodManager) throws HandlerException {
        Assert.notNull((Object)object, (String)"input object is null!");
        Assert.notNull((Object)methodManager, (String)"methodManager is null!");
        Map<String, String> fieldNameAndValueMap = ConditionFieldHandler.processFieldAndValue(object);
        Assert.notEmpty(fieldNameAndValueMap, (String)("Could'nt get field map of input object: " + object));
        return this.handleConditions(conditions, fieldNameAndValueMap, methodManager);
    }

    protected boolean handleConditions(Conditions conditions, Map<String, String> fieldNameAndValueMap, MethodManager methodManager) throws HandlerException {
        if (conditions == null) {
            return true;
        }
        if (!conditions.isAvailable()) {
            return false;
        }
        Conditions subConditions = conditions.getSubConditions();
        boolean flagOfSubConditions = this.handleConditions(subConditions, fieldNameAndValueMap, methodManager);
        List<Condition> conditionsCollection = conditions.getConditions();
        boolean flagOfConditionCollection = this.handleConditions(conditionsCollection, fieldNameAndValueMap, methodManager);
        LogicalOperation logicalOperation = conditions.getLogicalOperation();
        boolean result = LogicOperation.execute(logicalOperation, flagOfSubConditions, flagOfConditionCollection);
        if (logger.isDebugEnabled()) {
            logger.debug("Return result: {} of conditions: {} fieldMap: {} methodManager: {}", new Object[]{result, conditions, fieldNameAndValueMap, methodManager});
        }
        return result;
    }

    protected boolean handleConditions(Collection<Condition> conditionCollection, Map<String, String> fieldNameAndValueMap, MethodManager methodManager) throws HandlerException {
        if (CollectionUtils.isEmpty(conditionCollection)) {
            return true;
        }
        for (Condition condition : conditionCollection) {
            boolean b = this.handleCondition(condition, fieldNameAndValueMap, methodManager);
            if (b) continue;
            return false;
        }
        return true;
    }

    protected boolean handleCondition(Condition condition, Map<String, String> fieldNameAndValueMap, MethodManager methodManager) throws HandlerException {
        String configValue = condition.getValue();
        String fieldValue = this.handleFieldValue(condition, fieldNameAndValueMap, methodManager);
        if (StringUtils.isEmpty((Object)fieldValue) || StringUtils.isEmpty((Object)configValue)) {
            return false;
        }
        FieldQualified qualified = condition.getQualified();
        boolean b = this.handleFieldQualified(fieldValue, configValue, qualified);
        if (logger.isDebugEnabled()) {
            logger.debug("Returns result: {} of configValue: {} fieldValue: {} qualified: {}", new Object[]{b, configValue, fieldValue, qualified});
        }
        return b;
    }

    protected boolean handleFieldQualified(String fieldValue, String configValue, FieldQualified qualified) throws HandlerException {
        switch (qualified) {
            case EQUALS: {
                return fieldValue.equals(configValue);
            }
            case IN: {
                Collection<String> configs = Condition.splitConfigValue(configValue);
                return configs.contains(fieldValue);
            }
            case CONTAINS: {
                return fieldValue.contains(configValue);
            }
        }
        logger.error("Unknown qualified: {}", (Object)qualified);
        throw new HandlerException("Unknown qualified: " + (Object)((Object)qualified));
    }

    protected String handleFieldValue(Condition condition, Map<String, String> fieldNameAndValueMap, MethodManager methodManager) {
        String name = condition.getName();
        if (StringUtils.isEmpty((Object)name)) {
            return null;
        }
        String fieldValue = fieldNameAndValueMap.get(name);
        String valueConvertMethod = condition.getValueConvertMethod();
        if (valueConvertMethod != null) {
            ConvertMethod method = methodManager.getMethod(valueConvertMethod);
            try {
                return method.execute(fieldValue, condition);
            }
            catch (ConvertException e) {
                logger.error("Error when invoke method: " + method + " on condition: " + condition + ". ERROR: " + e.getMessage(), (Throwable)e);
            }
        }
        return fieldValue;
    }
}

