/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.logic.handle;

import com.xunlei.channel.common.logic.config.constants.LogicalOperation;
import com.xunlei.channel.common.logic.handle.HandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogicOperation {
    private static final Logger logger = LoggerFactory.getLogger(LogicOperation.class);

    public static boolean execute(LogicalOperation logicalOperation, boolean ... result) throws HandlerException {
        if (result == null || result.length == 0) {
            return false;
        }
        switch (logicalOperation) {
            case NOT: {
                return !LogicOperation.execute(LogicalOperation.AND, result);
            }
            case AND: {
                for (boolean flag : result) {
                    if (flag) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (boolean flag : result) {
                    if (!flag) continue;
                    return true;
                }
                return false;
            }
            case XOR: {
                if (result.length == 1) {
                    return result[0];
                }
                boolean flag = result[0] ^ result[1];
                if (result.length >= 3) {
                    for (int i = 2; i < result.length; ++i) {
                        flag ^= result[i];
                    }
                }
                return flag;
            }
            case XNOR: {
                boolean flag2;
                if (result.length == 1) {
                    return result[0];
                }
                boolean bl = flag2 = result[0] == result[1];
                if (result.length >= 3) {
                    for (int i = 2; i < result.length; ++i) {
                        boolean bl2 = flag2 = result[0] == result[i];
                        if (flag2) continue;
                        return false;
                    }
                }
                return flag2;
            }
        }
        logger.error("Unknown operation: {} for result: {}", (Object)logicalOperation, (Object)result);
        throw new HandlerException("Unsupport logic operation: " + (Object)((Object)logicalOperation));
    }
}

