/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.logic.config.method;

import com.xunlei.channel.common.logic.config.annotation.ConvertMethodName;
import com.xunlei.channel.common.logic.config.method.ConvertMethod;
import com.xunlei.channel.common.utils.scan.PackageScanner;
import com.xunlei.channel.common.utils.string.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodManager.class);
    private Map<String, ConvertMethod> methodNameAndInstanceMap = new HashMap<String, ConvertMethod>();
    public static final Package DEFAULT_PACKAGE = MethodManager.class.getPackage();

    private MethodManager(Package ... pkg) {
        this.init(pkg);
    }

    private void init(Package ... pkg) {
        PackageScanner packageScanner = PackageScanner.newScanner().addPackage(DEFAULT_PACKAGE).andInterface(ConvertMethod.class).ignoreInterface(true);
        for (Package aPackage : pkg) {
            packageScanner.addPackage(aPackage);
        }
        Collection methodClasses = packageScanner.scan();
        logger.info("Found method classes: {}", (Object)methodClasses);
        Iterator iterator = methodClasses.iterator();
        while (iterator.hasNext()) {
            Class methodClass;
            Class convertMethodClass = methodClass = (Class)iterator.next();
            String methodName = this.getMethodName(convertMethodClass);
            try {
                ConvertMethod convertMethod = (ConvertMethod)convertMethodClass.newInstance();
                ConvertMethod exists = this.methodNameAndInstanceMap.put(methodName, convertMethod);
                if (exists != null) {
                    logger.error("Already exists instance: {} of name: {} new: {}", new Object[]{exists, methodName, convertMethod});
                    continue;
                }
                logger.info("Put instance: {} of name: {}", (Object)convertMethod, (Object)methodName);
            }
            catch (Exception e) {
                logger.error("Error when instance class: " + convertMethodClass + ", Error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public ConvertMethod getMethod(String methodName) {
        return this.methodNameAndInstanceMap.get(methodName);
    }

    public static MethodManager newInstance() {
        return new MethodManager(DEFAULT_PACKAGE);
    }

    public static MethodManager newInstance(Package ... packages) {
        return new MethodManager(packages);
    }

    private String getMethodName(Class<ConvertMethod> convertMethodClass) {
        ConvertMethodName annotation = convertMethodClass.getAnnotation(ConvertMethodName.class);
        String value = annotation.value();
        if (StringUtils.isEmpty((Object)value)) {
            String simpleName = convertMethodClass.getSimpleName();
            return simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1);
        }
        return value;
    }
}

