/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.xunlei.channel.common.http.utils.JSON;
import com.xunlei.channel.common.http.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XML {
    private static XmlMapper xmlMapper = new XmlMapper();
    private static Logger logger = LoggerFactory.getLogger(XML.class);

    public static <T> T toJavaObject(InputStream in, Class<T> c) {
        try {
            return (T)xmlMapper.readValue(in, c);
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
    }

    public static <T> T toJavaObject(String in, Class<T> c) {
        try {
            return (T)xmlMapper.readValue(in, c);
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
    }

    public static <T> T toJavaObject(InputStream in, JavaType typeReference) {
        try {
            return (T)xmlMapper.readerFor(typeReference).readValue(in);
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
    }

    public static String toXMLString(Object o) {
        try {
            return xmlMapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            logger.warn("", (Throwable)e);
            throw new RuntimeException("json parse fail");
        }
    }

    public static String toXMLString(Object o, String root) {
        try {
            if (StringUtils.isEmpty(root)) {
                return xmlMapper.writeValueAsString(o);
            }
            return xmlMapper.writer().withRootName(root).writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            logger.warn("", (Throwable)e);
            throw new RuntimeException("xml parse fail");
        }
    }

    public static void main(String[] args) {
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        stringStringHashMap.put("aa", "v1");
        stringStringHashMap.put("bb", "v2");
        stringStringHashMap.put("cc", "v3");
        stringStringHashMap.put("dd", "v4");
        String s = JSON.toJSONString(stringStringHashMap, "jdpay");
        System.out.println(s);
    }
}

