/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.utils;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreeDesUtil {
    private static final Logger logger = LoggerFactory.getLogger(ThreeDesUtil.class);
    private static final String Algorithm = "DESede";
    private static final String PADDING = "DESede/ECB/NoPadding";
    public static final byte[] DEFAULT_KEY = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52};

    public static byte[] encrypt(byte[] keybyte, byte[] src) {
        try {
            SecretKeySpec deskey = new SecretKeySpec(keybyte, Algorithm);
            Cipher c1 = Cipher.getInstance(PADDING);
            c1.init(1, deskey);
            return c1.doFinal(src);
        }
        catch (NoSuchAlgorithmException e1) {
            logger.error("", (Throwable)e1);
        }
        catch (NoSuchPaddingException e2) {
            logger.error("", (Throwable)e2);
        }
        catch (Exception e3) {
            logger.error("", (Throwable)e3);
        }
        return null;
    }

    private static byte[] decrypt(byte[] keybyte, byte[] src) {
        try {
            SecretKeySpec deskey = new SecretKeySpec(keybyte, Algorithm);
            Cipher c1 = Cipher.getInstance(PADDING);
            c1.init(2, deskey);
            return c1.doFinal(src);
        }
        catch (NoSuchAlgorithmException e1) {
            logger.error("", (Throwable)e1);
        }
        catch (NoSuchPaddingException e2) {
            logger.error("", (Throwable)e2);
        }
        catch (Exception e3) {
            logger.error("", (Throwable)e3);
        }
        return null;
    }

    private static String byte2Hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
            if (n >= b.length - 1) continue;
            hs = hs + ":";
        }
        return hs.toUpperCase();
    }

    public static String encrypt2HexStr(byte[] keys, String sourceData) {
        try {
            int i;
            byte[] source = sourceData.getBytes("UTF-8");
            int merchantData = source.length;
            int x = (merchantData + 4) % 8;
            int y = x == 0 ? 0 : 8 - x;
            byte[] sizeByte = ThreeDesUtil.intToByteArray(merchantData);
            byte[] resultByte = new byte[merchantData + 4 + y];
            resultByte[0] = sizeByte[0];
            resultByte[1] = sizeByte[1];
            resultByte[2] = sizeByte[2];
            resultByte[3] = sizeByte[3];
            for (i = 0; i < merchantData; ++i) {
                resultByte[4 + i] = source[i];
            }
            for (i = 0; i < y; ++i) {
                resultByte[merchantData + 4 + i] = 0;
            }
            byte[] desdata = ThreeDesUtil.encrypt(keys, resultByte);
            return ThreeDesUtil.bytes2Hex(desdata);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decrypt4HexStr(byte[] keys, String data) {
        try {
            byte[] hexSourceData = ThreeDesUtil.hex2byte(data.getBytes("UTF-8"));
            byte[] unDesResult = ThreeDesUtil.decrypt(keys, hexSourceData);
            byte[] dataSizeByte = new byte[]{unDesResult[0], unDesResult[1], unDesResult[2], unDesResult[3]};
            int dsb = ThreeDesUtil.byteArrayToInt(dataSizeByte, 0);
            byte[] tempData = new byte[dsb];
            for (int i = 0; i < dsb; ++i) {
                tempData[i] = unDesResult[4 + i];
            }
            return ThreeDesUtil.hex2bin(ThreeDesUtil.toHexString(tempData));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String hex2bin(String hex) throws UnsupportedEncodingException {
        String digital = "0123456789abcdef";
        char[] hex2char = hex.toCharArray();
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int temp = digital.indexOf(hex2char[2 * i]) * 16;
            bytes[i] = (byte)((temp += digital.indexOf(hex2char[2 * i + 1])) & 0xFF);
        }
        return new String(bytes, "UTF-8");
    }

    private static String toHexString(byte[] ba) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < ba.length; ++i) {
            str.append(String.format("%x", ba[i]));
        }
        return str.toString();
    }

    private static String bytes2Hex(byte[] bts) {
        String des = "";
        String tmp = null;
        for (int i = 0; i < bts.length; ++i) {
            tmp = Integer.toHexString(bts[i] & 0xFF);
            if (tmp.length() == 1) {
                des = des + "0";
            }
            des = des + tmp;
        }
        return des;
    }

    public static byte[] hex2byte(byte[] b) {
        if (b.length % 2 != 0) {
            throw new IllegalArgumentException("length is not even!");
        }
        byte[] b2 = new byte[b.length / 2];
        for (int n = 0; n < b.length; n += 2) {
            String item = new String(b, n, 2);
            b2[n / 2] = (byte)Integer.parseInt(item, 16);
        }
        b = null;
        return b2;
    }

    private static byte[] intToByteArray(int i) {
        byte[] result = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    private static int byteArrayToInt(byte[] b, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }
}

