/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.utils;

import java.net.URLEncoder;
import java.util.Map;
import java.util.UUID;

public class StringUtils {
    private static String URL_ENCODING = "UTF-8";

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String generateRequestId() {
        return UUID.fromString(UUID.nameUUIDFromBytes(UUID.randomUUID().toString().getBytes()).toString()).toString().replace("-", "");
    }

    public static String toURLString(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        parameters.forEach((k, v) -> {
            try {
                sb.append(URLEncoder.encode(k, URL_ENCODING)).append("=").append(URLEncoder.encode(v, URL_ENCODING)).append('&');
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        if (sb.charAt(sb.length() - 1) == '&') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String bytes2Hex(byte[] bts) {
        String des = "";
        String tmp = null;
        for (int i = 0; i < bts.length; ++i) {
            tmp = Integer.toHexString(bts[i] & 0xFF);
            if (tmp.length() == 1) {
                des = des + "0";
            }
            des = des + tmp;
        }
        return des;
    }
}

