/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.channel.common.http.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSON {
    private static ObjectMapper mapper = new ObjectMapper();
    private static Logger logger = LoggerFactory.getLogger(JSON.class);

    public static String toJSONString(Object o) {
        try {
            return mapper.writer().writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            logger.warn("", (Throwable)e);
            throw new RuntimeException("json parse fail");
        }
    }

    public static String toJSONString(Object o, String root) {
        try {
            if (StringUtils.isEmpty(root)) {
                return mapper.writeValueAsString(o);
            }
            return mapper.writer().withRootName(root).writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            logger.warn("", (Throwable)e);
            throw new RuntimeException("json parse fail");
        }
    }

    public static <T> T toJavaObject(Map map, Class<T> c) {
        return (T)mapper.convertValue((Object)map, c);
    }

    public static <T> T toJavaObject(String json, Class<T> c) {
        try {
            return (T)mapper.readValue(json, c);
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
    }

    public static <T> T toJavaObject(InputStream in, Class<T> c) {
        try {
            return (T)mapper.readValue(in, c);
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            throw new RuntimeException("json parse fail");
        }
    }

    public static <T> T toJavaObject(InputStream in, TypeReference typeReference) {
        try {
            return (T)mapper.readerFor(typeReference).readValue(in);
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
    }

    public static <T> T toJavaObject(InputStream in, JavaType typeReference) {
        try {
            return (T)mapper.readerFor(typeReference).readValue(in);
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
    }
}

