/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.utils;

import com.xunlei.channel.common.http.annotation.NotNull;
import com.xunlei.channel.common.http.annotation.ParamAttr;
import com.xunlei.channel.common.http.utils.JSON;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldUtils {
    private static Logger logger = LoggerFactory.getLogger(FieldUtils.class);
    private static final Set<Class> set;

    public static Map<String, String> toMap(Object o) {
        HashMap<String, String> map = new HashMap<String, String>();
        Arrays.stream(o.getClass().getDeclaredFields()).filter(f -> f.getAnnotation(NotNull.class) == null && !Modifier.isStatic(f.getModifiers())).forEach(f -> {
            Optional<String> stringValue = FieldUtils.getStringValue(f, o);
            if (!stringValue.isPresent()) {
                return;
            }
            ParamAttr attr = f.getAnnotation(ParamAttr.class);
            String key = attr == null || "".equals(attr.paramKey()) ? f.getName() : attr.paramKey();
            map.put(key, stringValue.get());
        });
        return map;
    }

    public static Optional<String> getStringValue(Field f, Object o) {
        try {
            f.setAccessible(true);
            Object value = f.get(o);
            if (value == null) {
                return Optional.empty();
            }
            if (FieldUtils.isPrimitive(f.getType())) {
                return Optional.ofNullable(String.valueOf(value));
            }
            String stringValue = JSON.toJSONString(value);
            return Optional.of(stringValue);
        }
        catch (IllegalAccessException e) {
            logger.warn("", (Throwable)e);
            return Optional.empty();
        }
    }

    public static String toStringValue(Object value) {
        if (FieldUtils.isPrimitive(value.getClass())) {
            return String.valueOf(value);
        }
        return JSON.toJSONString(value);
    }

    public static void writeLong(Field field, Object o, Long l) {
        try {
            field.setAccessible(true);
            field.setLong(o, l);
        }
        catch (IllegalAccessException e) {
            logger.warn("", (Throwable)e);
            throw new RuntimeException("write value fail");
        }
    }

    public static void write(Field f, Object o, String textValue) {
        try {
            f.setAccessible(true);
            PropertyEditor editor = PropertyEditorManager.findEditor(f.getType());
            editor.setAsText(textValue);
            f.set(o, editor.getValue());
        }
        catch (IllegalAccessException e) {
            logger.warn("", (Throwable)e);
            throw new RuntimeException("write value fail");
        }
    }

    public static boolean isPrimitive(Class c) {
        return c.isPrimitive() || set.contains(c);
    }

    static {
        HashSet<Class> wrapper = new HashSet<Class>();
        wrapper.add(Boolean.class);
        wrapper.add(Character.class);
        wrapper.add(Byte.class);
        wrapper.add(Short.class);
        wrapper.add(Integer.class);
        wrapper.add(Long.class);
        wrapper.add(Float.class);
        wrapper.add(Double.class);
        wrapper.add(Void.class);
        wrapper.add(String.class);
        set = Collections.unmodifiableSet(wrapper);
    }
}

