/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.service;

import com.xunlei.channel.common.http.annotation.RemoteService;
import com.xunlei.channel.common.http.core.ApiAttr;
import com.xunlei.channel.common.http.core.ApiAttrCreator;
import com.xunlei.channel.common.http.core.Clients;
import com.xunlei.channel.common.http.core.RequestBuilder;
import com.xunlei.channel.common.http.core.RequestDataWrapper;
import com.xunlei.channel.common.http.core.RequestMetaData;
import com.xunlei.channel.common.http.core.ResponseResolver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceProxy
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(ServiceProxy.class);
    private Map<Method, ApiAttr> apiAttrMap;

    public ServiceProxy(Set<Class<?>> apiServices) {
        HashMap map = new HashMap();
        apiServices.stream().filter(c -> c.getAnnotation(RemoteService.class) != null && c.isInterface()).forEach(c -> Arrays.stream(c.getMethods()).forEach(m -> {
            ApiAttr apiAttr = ApiAttrCreator.createApiAttr(m);
            map.put(m, apiAttr);
        }));
        this.apiAttrMap = Collections.unmodifiableMap(map);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        logger.debug("invoke method#{},Thread#{}", (Object)method.getName(), (Object)Thread.currentThread().getName());
        ApiAttr apiAttr = this.apiAttrMap.get(method);
        if (apiAttr == null) {
            throw new RuntimeException("can't find method attributes");
        }
        RequestMetaData metaData = RequestDataWrapper.wrapRequestData(apiAttr, args);
        return ResponseResolver.resolve(Clients.getDefaultClient().sendRequest(RequestBuilder.build(metaData)), apiAttr.getReturnClass());
    }
}

