/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.predefine.jd.uniorder;

import com.xunlei.channel.common.http.predefine.jd.uniorder.EncryptResponse;
import com.xunlei.channel.common.http.predefine.jd.uniorder.JDUniorderResponse;
import com.xunlei.channel.common.http.utils.RSACoder;
import com.xunlei.channel.common.http.utils.SHAUtil;
import com.xunlei.channel.common.http.utils.ThreeDesUtil;
import com.xunlei.channel.common.http.utils.XML;
import com.xunlei.channel.config.Config;
import com.xunlei.channel.config.predefine.JDH5Config;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDUnionOrderResponseProcessor
implements Function<Response, JDUniorderResponse> {
    private static Logger logger = LoggerFactory.getLogger(JDUnionOrderResponseProcessor.class);
    private static Pattern pattern = Pattern.compile("(.*)<sign>(.*)</sign>(.*)");
    private static final String hexString = "0123456789ABCDEF";

    @Override
    public JDUniorderResponse apply(Response response) {
        EncryptResponse encryptResponse = XML.toJavaObject(response.body().byteStream(), EncryptResponse.class);
        if (encryptResponse.getResult().isSuccess()) {
            String encrypt = encryptResponse.getEncrypt();
            try {
                byte[] deskey = Base64.getDecoder().decode(((JDH5Config)Config.KVBean(JDH5Config.class)).getDesKey().getStringVal());
                String data = ThreeDesUtil.decrypt4HexStr(deskey, new String(Base64.getDecoder().decode(encrypt), "utf-8"));
                logger.info("get jd raw response after decrypt data#{}", (Object)data);
                Matcher matcher = pattern.matcher(data);
                if (matcher.find()) {
                    String sign = matcher.group(2);
                    String raw = matcher.group(1) + matcher.group(3);
                    String pre = SHAUtil.encrypt(raw, "SHA-256");
                    String pubKey = (String)((JDH5Config)Config.KVBean(JDH5Config.class)).getRsaPublicKey().val();
                    String result = JDUnionOrderResponseProcessor.bytesToString(RSACoder.decryptByPublicKey(Base64.getDecoder().decode(sign), pubKey));
                    if (result.equals(pre)) {
                        JDUniorderResponse jdUniorderResponse = XML.toJavaObject(data, JDUniorderResponse.class);
                        return jdUniorderResponse;
                    }
                    logger.warn("check sign fail: key#{},sign#{},pre#{}", new Object[]{pubKey, sign, pre});
                }
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        } else {
            logger.warn("jd response fail code#{},desc#{}", (Object)encryptResponse.getResult().getCode(), (Object)encryptResponse.getResult().getDesc());
        }
        return null;
    }

    public static String bytesToString(byte[] src) throws Exception {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        String bytes = stringBuilder.toString();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length() / 2);
        for (int i = 0; i < bytes.length(); i += 2) {
            baos.write(hexString.indexOf(bytes.charAt(i)) << 4 | hexString.indexOf(bytes.charAt(i + 1)));
        }
        return new String(baos.toByteArray());
    }
}

