/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.predefine.jd.uniorder;

import com.xunlei.channel.common.http.core.RequestMetaData;
import com.xunlei.channel.common.http.utils.RSACoder;
import com.xunlei.channel.common.http.utils.SHAUtil;
import com.xunlei.channel.common.http.utils.SignUtil;
import com.xunlei.channel.common.http.utils.XML;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDSignUtil
implements SignUtil {
    private static Logger logger = LoggerFactory.getLogger(JDSignUtil.class);
    public static final String SHA256 = "SHA-256";
    public static final String HEAD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String JDEL = "jdpay";

    @Override
    public String sortParams(RequestMetaData data) {
        return HEAD + XML.toXMLString(data.getBody(), JDEL);
    }

    @Override
    public String sign(RequestMetaData data, String key) {
        String sorted = this.sortParams(data);
        return JDSignUtil.sign(sorted, key);
    }

    public static String sign(String raw, String key) {
        logger.debug("sorted string#{}", (Object)raw);
        try {
            String presign = SHAUtil.encrypt(raw, SHA256);
            byte[] d = RSACoder.encryptByPrivateKey(presign.getBytes("utf-8"), key);
            return new String(Base64.getEncoder().encode(d));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void main(String[] args) throws NoSuchAlgorithmException {
        String str = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><jdpay><orderType>1</orderType><amount>1</amount><tradeNum>1503391852734</tradeNum><merchant>110346473002</merchant><tradeDesc>aaa</tradeDesc><version>V2.0</version><tradeTime>20170822165053</tradeTime><tradeName>test</tradeName><notifyUrl>http://test-proxy.pay.xunlei.com:14445/gateway/jdpayh5/return</notifyUrl><currency>CNY</currency><callbackUrl>adsf</callbackUrl><tradeType>QR</tradeType></jdpay>";
        String str2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><jdpay><tradeTime>20170822165228</tradeTime><orderType>1</orderType><tradeName>test</tradeName><amount>1</amount><tradeNum>1503391947645</tradeNum><merchant>110346473002</merchant><notifyUrl>http://test-proxy.pay.xunlei.com:14445/gateway/jdpayh5/return</notifyUrl><currency>CNY</currency><callbackUrl>adsf</callbackUrl><tradeDesc>aaa</tradeDesc><version>V2.0</version><tradeType>QR</tradeType></jdpay>";
        System.out.println(SHAUtil.encrypt(str, SHA256));
        System.out.println(SHAUtil.encrypt(str2, SHA256));
    }
}

