/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.object;

import com.xunlei.channel.common.http.core.ApiAttr;
import com.xunlei.channel.common.http.core.ApiAttrCreator;
import com.xunlei.channel.common.http.core.Clients;
import com.xunlei.channel.common.http.core.RequestBuilder;
import com.xunlei.channel.common.http.core.RequestDataProcessor;
import com.xunlei.channel.common.http.core.RequestDataWrapper;
import com.xunlei.channel.common.http.core.RequestMetaData;
import com.xunlei.channel.common.http.core.ResponseResolver;
import com.xunlei.channel.common.http.object.RequestObject;
import com.xunlei.channel.config.support.FieldProcessorAware;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestObject<T>
extends FieldProcessorAware
implements RequestObject {
    private static Logger logger = LoggerFactory.getLogger(AbstractRequestObject.class);
    protected ApiAttr apiAttr;
    private static HashMap<Class<? extends RequestObject>, ApiAttr> cache = new HashMap();

    public AbstractRequestObject() {
        ApiAttr cached = cache.get(this.getClass());
        if (cached == null) {
            this.apiAttr = ApiAttrCreator.createApiAttr(this);
            cache.put(this.getClass(), this.apiAttr);
        } else {
            this.apiAttr = cached;
        }
    }

    @Override
    public Optional<T> requestRemote() {
        try {
            RequestMetaData requestMetaData = RequestDataWrapper.wrapRequestData(this.apiAttr, this);
            Optional<Response> response = Clients.getDefaultClient().sendRequest(RequestBuilder.build(requestMetaData));
            Function<Response, Response> custom = this.customResponseProcess();
            if (response.isPresent() && custom != null) {
                return Optional.ofNullable(custom.apply(response.get()));
            }
            return Optional.ofNullable(ResponseResolver.resolve(response, this.apiAttr.getReturnClass()));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return Optional.empty();
        }
    }

    public RequestDataProcessor getSpecialDataProcessor() {
        return null;
    }

    protected Function<Response, T> customResponseProcess() {
        return null;
    }
}

