/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.core;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.xunlei.channel.common.http.annotation.Format;
import com.xunlei.channel.common.http.core.ApiAttr;
import com.xunlei.channel.common.http.utils.JSON;
import com.xunlei.channel.common.http.utils.XML;
import java.util.List;
import java.util.Optional;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseResolver {
    private static Logger logger = LoggerFactory.getLogger(ResponseResolver.class);

    public static Object resolve(Optional<Response> response, ApiAttr.ReturnClass returnClass) {
        try (ResponseBody body = null;){
            Optional optional;
            if (response.isPresent() && response.get().isSuccessful()) {
                Object o;
                body = response.get().body();
                if (returnClass.isList()) {
                    TypeFactory factory = TypeFactory.defaultInstance();
                    o = returnClass.getFormat() != null && returnClass.getFormat().format() == Format.DataFormat.XML ? XML.toJavaObject(body.byteStream(), (JavaType)factory.constructCollectionLikeType(List.class, returnClass.getClazz())) : JSON.toJavaObject(body.byteStream(), (JavaType)factory.constructCollectionLikeType(List.class, returnClass.getClazz()));
                } else {
                    o = returnClass.getFormat() != null && returnClass.getFormat().format() == Format.DataFormat.XML ? XML.toJavaObject(body.byteStream(), returnClass.getClazz()) : JSON.toJavaObject(body.byteStream(), returnClass.getClazz());
                }
                if (returnClass.isOptional()) {
                    optional = Optional.ofNullable(o);
                    return optional;
                }
                optional = o;
                return optional;
            }
            if (returnClass.isOptional()) {
                Optional o = Optional.empty();
                return o;
            }
            try {
                String msg = response.isPresent() ? "return http code:" + response.get().code() + ",msg:" + response.get().message() : "no response";
                throw new RuntimeException("request fail" + msg);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                if (returnClass.isOptional()) {
                    optional = Optional.empty();
                    return optional;
                }
                throw e;
            }
        }
    }
}

