/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.core;

import com.xunlei.channel.common.http.annotation.Format;
import com.xunlei.channel.common.http.annotation.ParamAttr;
import com.xunlei.channel.common.http.annotation.Sign;
import com.xunlei.channel.config.annotation.ConfigValue;
import com.xunlei.channel.config.support.ConfigSupport;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class RequestMetaData {
    private final String rawURL;
    private final TreeMap<String, String> paths;
    private final TreeMap<String, String> body;
    private final TreeMap<String, String> params;
    private final File file;
    private final String fileName;
    private final Format format;

    public RequestMetaData(String rawURL, HashMap<String, String> paths, HashMap<String, String> body, HashMap<String, String> params, File file, String fileName, Format format) {
        this.rawURL = rawURL;
        this.paths = new TreeMap<String, String>(paths);
        this.body = new TreeMap<String, String>(body);
        this.params = new TreeMap<String, String>(params);
        this.file = file;
        this.fileName = fileName;
        this.format = format;
    }

    public String getRawURL() {
        return this.rawURL;
    }

    public Map<String, String> getPaths() {
        return this.paths;
    }

    public Map<String, String> getBody() {
        return this.body;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public RequestMetaData signIfNecessary(Sign sign) {
        try {
            if (sign != null) {
                String signKey = (String)ConfigSupport.extractConfigValue((ConfigValue)sign.key()).val();
                if (signKey == null) {
                    throw new RuntimeException("can't get sign key!");
                }
                String signed = sign.signUtil().newInstance().sign(this, signKey);
                if (sign.location() == ParamAttr.Location.QUERY_STRING) {
                    this.params.put(sign.name(), signed);
                    if (!"ignore_type".equals(sign.typeName())) {
                        this.params.put(sign.typeName(), sign.type().name());
                    }
                } else {
                    this.body.put(sign.name(), signed);
                    if (!"ignore_type".equals(sign.typeName())) {
                        this.body.put(sign.typeName(), sign.type().name());
                    }
                }
            }
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Format getFormat() {
        return this.format;
    }
}

